/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongPredicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEChunkTicketManager;
import qouteall.imm_ptl.core.ducks.IEServerChunkManager;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.mixin.common.chunk_sync.IEDistanceManager;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;
import qouteall.q_misc_util.my_util.RateStat;

public class ImmPtlChunkTickets {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final TicketType<ChunkPos> TICKET_TYPE = TicketType.m_9462_((String)"imm_ptl", Comparator.comparingLong(ChunkPos::m_45588_));
    private static boolean enableDebugRateStat = false;
    private static final RateStat debugRateStat = new RateStat("imm_ptl_chunk_ticket");
    public static final WeakHashMap<ServerLevel, ImmPtlChunkTickets> BY_DIMENSION = new WeakHashMap();
    private final Long2ObjectOpenHashMap<ChunkTicketInfo> chunkPosToTicketInfo = new Long2ObjectOpenHashMap();
    private final ArrayList<LongLinkedOpenHashSet> chunksToAddTicketByDistance = new ArrayList();
    private final LongOpenHashSet waitingForLoading = new LongOpenHashSet();
    private boolean isValid = true;
    public final int throttlingLimit = 4;
    public int immediateTaskQuota = 0;

    public static void init() {
        DynamicDimensionsImpl.beforeRemovingDimensionSignal.connect(ImmPtlChunkTickets::onDimensionRemove);
        IPGlobal.serverCleanupSignal.connect(ImmPtlChunkTickets::cleanup);
    }

    private ImmPtlChunkTickets() {
    }

    public static ImmPtlChunkTickets get(ServerLevel world) {
        return BY_DIMENSION.computeIfAbsent(world, k -> new ImmPtlChunkTickets());
    }

    public void markForLoading(long chunkPos, int distanceToSource, int generation) {
        Validate.isTrue((distanceToSource >= 0 && distanceToSource <= 32 ? 1 : 0) != 0);
        ChunkTicketInfo info = (ChunkTicketInfo)this.chunkPosToTicketInfo.get(chunkPos);
        if (info == null) {
            info = new ChunkTicketInfo(generation, distanceToSource);
            this.chunkPosToTicketInfo.put(chunkPos, (Object)info);
            this.getQueueByDistance(distanceToSource).add(chunkPos);
        } else if (generation != info.lastUpdateGeneration) {
            info.lastUpdateGeneration = generation;
            int oldDistanceToSource = info.distanceToSource;
            info.distanceToSource = distanceToSource;
            if (this.getQueueByDistance(oldDistanceToSource).remove(chunkPos)) {
                this.getQueueByDistance(distanceToSource).add(chunkPos);
            }
        } else if (distanceToSource < info.distanceToSource) {
            int oldDistanceToSource = info.distanceToSource;
            info.distanceToSource = distanceToSource;
            if (this.getQueueByDistance(oldDistanceToSource).remove(chunkPos)) {
                this.getQueueByDistance(distanceToSource).add(chunkPos);
            }
        }
    }

    private LongLinkedOpenHashSet getQueueByDistance(int distanceToSource) {
        return Helper.arrayListComputeIfAbsent(this.chunksToAddTicketByDistance, distanceToSource, LongLinkedOpenHashSet::new);
    }

    public void tick(ServerLevel world) {
        this.immediateTaskQuota = 0;
        this.flushThrottling(world);
    }

    public void flushThrottling(ServerLevel world) {
        if (!world.m_7654_().m_18695_()) {
            LOGGER.error("Called in a non-server-main thread.", new Throwable());
            return;
        }
        if (enableDebugRateStat) {
            debugRateStat.update();
        }
        if (!this.isValid) {
            LOGGER.error("flushing when invalid {}", (Object)world);
            return;
        }
        if (!world.m_7654_().m_130010_()) {
            return;
        }
        DistanceManager distanceManager = ImmPtlChunkTickets.getDistanceManager(world);
        Executor mainThreadExecutor = ((IEDistanceManager)distanceManager).ip_getMainThreadExecutor();
        this.waitingForLoading.removeIf(chunkPos -> {
            ChunkHolder chunkHolder = ImmPtlChunkTickets.getChunkHolder(world, chunkPos);
            if (chunkHolder == null) {
                return true;
            }
            Either resultNow = chunkHolder.m_140073_().getNow(null);
            return resultNow != null && resultNow.left().isPresent();
        });
        for (LongLinkedOpenHashSet queue : this.chunksToAddTicketByDistance) {
            if (queue == null) continue;
            while (!queue.isEmpty()) {
                if (this.waitingForLoading.size() >= 4) {
                    return;
                }
                long chunkPos2 = queue.removeFirstLong();
                if (this.chunkPosToTicketInfo.containsKey(chunkPos2)) {
                    ImmPtlChunkTickets.addTicket(distanceManager, chunkPos2);
                    this.waitingForLoading.add(chunkPos2);
                    continue;
                }
                LOGGER.warn("Chunk {} is not in the queue", (Object)new ChunkPos(chunkPos2));
            }
        }
    }

    private static void addTicket(DistanceManager distanceManager, long chunkPos) {
        if (!IPConfig.getConfig().enableImmPtlChunkLoading) {
            return;
        }
        ChunkPos chunkPosObj = new ChunkPos(chunkPos);
        distanceManager.m_140840_(TICKET_TYPE, chunkPosObj, ImmPtlChunkTickets.getLoadingRadius(), (Object)chunkPosObj);
        if (enableDebugRateStat) {
            debugRateStat.hit();
        }
    }

    public void purge(ServerLevel world, LongPredicate shouldKeepLoadingFunc) {
        DistanceManager distanceManager = ImmPtlChunkTickets.getDistanceManager(world);
        this.chunkPosToTicketInfo.long2ObjectEntrySet().removeIf(e -> {
            long chunkPos = e.getLongKey();
            ChunkTicketInfo ticketInfo = (ChunkTicketInfo)e.getValue();
            boolean keepLoading = shouldKeepLoadingFunc.test(chunkPos);
            if (!keepLoading) {
                this.waitingForLoading.remove(chunkPos);
                boolean pendingTicketAdding = this.getQueueByDistance(ticketInfo.distanceToSource).remove(chunkPos);
                if (!pendingTicketAdding) {
                    ChunkPos chunkPosObj = new ChunkPos(chunkPos);
                    distanceManager.m_140849_(TICKET_TYPE, chunkPosObj, ImmPtlChunkTickets.getLoadingRadius(), (Object)chunkPosObj);
                }
                return true;
            }
            return false;
        });
    }

    public int getLoadedChunkNum() {
        return this.chunkPosToTicketInfo.size();
    }

    public static void onDimensionRemove(ResourceKey<Level> dimension) {
        ServerLevel world = McHelper.getServerWorld(dimension);
        ImmPtlChunkTickets dimTicketManager = BY_DIMENSION.remove(world);
        if (dimTicketManager == null) {
            return;
        }
        ImmPtlChunkTickets.removeAllTicketsInWorld(world, dimTicketManager);
    }

    private static void removeAllTicketsInWorld(ServerLevel world, ImmPtlChunkTickets dimTicketManager) {
        DistanceManager ticketManager = ImmPtlChunkTickets.getDistanceManager(world);
        dimTicketManager.chunkPosToTicketInfo.keySet().forEach(pos -> {
            SortedArraySet<Ticket<?>> tickets = ((IEChunkTicketManager)ImmPtlChunkTickets.getDistanceManager(world)).portal_getTicketSet(pos);
            List<Ticket> toRemove = tickets.stream().filter(t -> t.m_9428_() == TICKET_TYPE).toList();
            ChunkPos chunkPos = new ChunkPos(pos);
            for (Ticket ticket : toRemove) {
                ticketManager.m_140849_(TICKET_TYPE, chunkPos, ticket.m_9433_(), (Object)chunkPos);
            }
        });
        dimTicketManager.isValid = false;
    }

    public static int getLoadingRadius() {
        if (IPGlobal.activeLoading) {
            return 2;
        }
        return 1;
    }

    public static ChunkHolder getChunkHolder(ServerLevel world, long chunkPos) {
        return ((IEThreadedAnvilChunkStorage)world.m_7726_().f_8325_).ip_getChunkHolder(chunkPos);
    }

    public static DistanceManager getDistanceManager(ServerLevel world) {
        return ((IEServerChunkManager)world.m_7726_()).ip_getDistanceManager();
    }

    private static void cleanup() {
        for (ImmPtlChunkTickets immPtlChunkTickets : BY_DIMENSION.values()) {
            immPtlChunkTickets.isValid = false;
        }
        BY_DIMENSION.clear();
    }

    public static class ChunkTicketInfo {
        public int lastUpdateGeneration;
        public int distanceToSource;

        public ChunkTicketInfo(int lastUpdateGeneration, int distanceToSource) {
            this.lastUpdateGeneration = lastUpdateGeneration;
            this.distanceToSource = distanceToSource;
        }
    }
}

